/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.entity;

import forge.com.cursee.more_bows_and_arrows.core.entity.TieredArrowEntity;
import forge.com.cursee.more_bows_and_arrows.core.item.TieredBowItem;
import forge.com.cursee.more_bows_and_arrows.core.tier.BowTier;
import forge.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.DragonBreathUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.FireworkUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.PaperEffectsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ArrowHitsBlockInteractions {
    public static void interact(TieredArrowEntity tieredArrowEntity, @Nullable Entity nullableOwner, BlockHitResult blockHitResult) {
        if (!(nullableOwner instanceof Player)) {
            return;
        }
        Player player = (Player)nullableOwner;
        Level level = player.m_9236_();
        ItemStack itemStack = player.m_21205_();
        Item playerMainHandItem = itemStack.m_41720_();
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos relative = blockPos.m_121945_(direction);
        switch (tieredArrowEntity.getVariant()) {
            case BAMBOO: {
                if (!(playerMainHandItem instanceof TieredBowItem)) {
                    return;
                }
                if (((TieredBowItem)playerMainHandItem).tier != BowTier.BAMBOO) {
                    return;
                }
                BlockState state = level.m_8055_(blockPos);
                if (!Blocks.f_50571_.m_49966_().m_60710_((LevelReader)player.m_9236_(), blockPos)) break;
                if (Feature.m_159759_((BlockState)state)) {
                    level.m_7731_(blockPos, Blocks.f_50599_.m_49966_(), 3);
                    level.m_7731_(blockPos.m_7494_(), Blocks.f_50571_.m_49966_(), 3);
                    break;
                }
                if (!state.m_60713_(Blocks.f_50571_)) break;
                level.m_7731_(blockPos.m_7494_(), Blocks.f_50571_.m_49966_(), 3);
                break;
            }
            case BLAZE_ROD: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, player.m_9236_());
                break;
            }
            case DRAGON_BREATH: {
                DragonBreathUtil.createAreaEffectCloud(player, blockHitResult.m_82425_());
                break;
            }
            case ECHO: {
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_5594_(player, blockHitResult.m_82425_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case EGG: {
                Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(player.m_9236_());
                if (chicken == null) break;
                chicken.m_6027_((double)relative.m_123341_(), (double)relative.m_123342_(), (double)relative.m_123343_());
                level.m_7967_((Entity)chicken);
                break;
            }
            case ENDER_PEARL: {
                player.m_6021_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                break;
            }
            case FIREWORK: {
                FireworkUtil.createRandomFireworkFromEntity((LivingEntity)player, blockHitResult.m_82425_());
                break;
            }
            case FIRE_CHARGE: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, player.m_9236_());
                break;
            }
            case FLINT: {
                if (!(playerMainHandItem instanceof TieredBowItem)) break;
                TieredBowItem bow = (TieredBowItem)playerMainHandItem;
                if (bow.tier != BowTier.IRON) break;
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, player.m_9236_());
                break;
            }
            case FLINT_AND_STEEL: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, player.m_9236_());
                break;
            }
            case LADDER: {
                player.m_6021_((double)player.m_20183_().m_123341_(), (double)blockPos.m_121945_(direction).m_123342_(), (double)player.m_20183_().m_123343_());
                break;
            }
            case LIGHTNING_ROD: {
                CommonEffectsUtil.lightingCausedByPlayer(player, blockPos);
                break;
            }
            case NETHER_STAR: {
                level.m_254849_((Entity)player, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 4.0f, Level.ExplosionInteraction.TNT);
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomBlockEffects(player, blockHitResult);
                break;
            }
            case REDSTONE: {
                if (!level.m_8055_(blockPos).m_61138_((Property)RedStoneOreBlock.f_55450_)) break;
                level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)RedStoneOreBlock.f_55450_, (Comparable)Boolean.valueOf(true)), 11);
                break;
            }
            case TNT: {
                level.m_254849_((Entity)player, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 2.0f, Level.ExplosionInteraction.TNT);
                break;
            }
            case WATER_BOTTLE: {
                if (level.m_8055_(blockPos).m_61138_((Property)CampfireBlock.f_51227_)) {
                    level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 11);
                }
                if (!level.m_8055_(relative).m_60713_(Blocks.f_50083_)) break;
                level.m_7471_(relative, false);
            }
        }
    }
}

